// VERSION: Scilab: 5.4.1 
// OS: windows 7

//CAPTION: To find wheather the system is linear or non linear for the given signal y(n)=[x(n)]^2+B;

clc;
clear all;
close;
 
//Properties of DT Systems(Linearity)
//y(n)=[x(n)]^2+B;
 
x1=input('Enter first input sequence:');
n=length(x1);
x2=input('Enter second input sequence:');
a=input('Enter scaling constant(a):');
b=input('Enter scaling constant(b):');
B=input('Enter scaling constant(B):');
 
y1=x1.^2+B;
y2=x2.^2+B;
rhs=a*y1+b*y2;
x3=a*x1+b*x2;
lhs=x3.^2+B;
 
subplot(2,2,1);
plot2d3(0:n-1,x1);
xlabel('Time');
ylabel('Amplitude');
title('First input sequence');
subplot(2,2,2);
plot2d3(0:n-1,x2);
xlabel('Time');
ylabel('Amplitude');
title('Second input sequence');
subplot(2,2,3);
plot2d3(0:n-1,lhs);
xlabel('Time');
ylabel('Amplitude');
title('LHS');
subplot(2,2,4);
plot2d3(0:n-1,rhs);
xlabel('Time');
ylabel('Amplitude');
title('RHS');
 
if(lhs==rhs)
    disp('system is linear');
else
    disp('system is non-linear');

end;


//// Input Data

//Enter first input sequence:[1 2 3 4]
//Enter second input sequence:[ 2 2 2 2 ]
//Enter scaling constant(a):1
//Enter scaling constant(b):1
//Enter scaling constant(B):2

/// Output:  system is non-linear
//See graphic window
